#!/bin/bash
#
# Share Enabler . Share mounting help for user context across logins
#
# This script helps overcome share points being mounted in the wrong
# user context.  This can happen when users switch consoles logging in
# and out.  We want to make sure the mount point stays consistent
# This script should be run as root in order to not have to give the
# User Super-User privileges. It should check to see wether or not
# a user is logged in and act accordingly.  It will source the
# share points you want it to control from a config file.
# This script should be run as a LaunchDaemon and work when
# a path is touched by a login action.  
#
@ created by andy@nugeometry.com
# Version 1.1
##################################################################

# Boolean 0 = not daemon mode, 1 = daemon mode true
daemon_mode=$1

#Set my path
my_path=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
echo "$my_path"

#Set log file
log_file="/dev/tty"
echo "$log_file"

# Set the Magic File name more complex for added security
# however this file will be readable if someone were to peak
# This much match the magic file name in the user_share_enabler.sh script
magic_file="/tmp/123098.file"

#If the Magic file DNE then exit
if [ ! -f "${magic_file}" ]; then
	echo "Magic file does not exist. Exiting..." >> "$log_file"
	exit 0
fi


# Check to see who is logging in gather information
user=`/usr/bin/stat -f '%Su' /dev/console`

#Source Config File
#source "${my_path}/config.txt"
config_file="${my_path}/share_enabler.config"


#Show environment
echo "Script run at" > "$log_file"
date >> "$log_file"
echo "my_path = ${my_path}" >> "$log_file"
echo "daemon_mode= ${daemon_mode}" >> "$log_file"
echo "" >> "$log_file"

#Read each line in the config file and check to see if it is mounted in the
#proper user context for $user. If not unmount the drive.
#This is broken down into 2 checks. One for mounts that are located 
#at the mount point we want to use and secondly ones that are redundant
while read line
do
	echo "Checking to see if our mount point $line is mounted" >> "$log_file"
	mount_user=`mount | grep "on ${line}" | sed "s/\([/;:a-zA-Z@\.(, ]*by\) \([a-zA-Z0-9]*\))$/\2/"`
	mount_exists=`mount | grep "on ${line}"`
	echo "The user is $mount_user" >> "$log_file"
	echo "This mount exists '${mount_exists}'" >> "$log_file"
	if [ "${user}" != "${mount_user}" ] && [ "${mount_exists}" != "" ]; then
		echo "Found invailed mount unmounting"
		umount -f $line
	fi
	echo "" >> "$log_file"
	
	echo "Cleaning up and other redundent mounts" >> "$log_file"
	# Remove any mounts for the mount point
	# This may need sudoers file to allow this command
	remove_check=`mount | grep "on ${line}-"`
	echo "Remove Check = '${remove_check}'" >> "$log_file"
	remove_loop_count=0
	while [ "$remove_check" != "" ] && [ $remove_loop_count -le 20 ] ; do

		echo "Trying to remove bad mounts" >> "$log_file"
		mountp=`echo $remove_check | awk '{print $3}'`
		
		umount -f "$mountp"
		remove_check=`mount | grep "on ${line}-"`
		remove_loop_count=$[$remove_loop_count +1]
		#If we cant remove these bad mounts something is wrong
		if [ $remove_loop_count -eq 20 ]; then
			echo "Cant remove bad mounts.  Something is wrong." >> "$log_file"
			exit 1
		fi
				
	done

	#Check to see if the mount point folder is already at the location.  If so this will cause an
	#Issue with Finder mounts, incorrectly mounting it at some random folder.  Test the mount point and
	#move the folder to a backup location in case this folder was actually intentionally there

	echo "" >> "$log_file"
	echo "Checking for mount point destination folder existence." >> "$log_file"
	echo "" >> "$log_file"
	echo "Mount point is '${line}'" >> "$log_file"
	if [ -d $line ]; then
		echo "Mount point folder found" >> "$log_file"
		#Double check this is not mounted
		#add a space to the end to make sure that it is a proper mount
		mount | grep "${line} "
		if [ $? == 0 ]; then
		
			echo "IT IS A MOUNT!!" >> "$log_file"
			echo "Can't move yet, let the script continue try again later" >> "$log_file"
		else
			echo "Attempting to move the mount_point folder" >> "$log_file"
			#set name
			jname=${line}_backup_`date +%Y%m%d_%H%M%S`
			echo "Folder Name will be ${jname}" >> "$log_file"
			echo "Running mv -v ${line} ${jname}" >> "$log_file"
			mv -v ${line} ${jname} >> "$log_file"
			if [ $? == 0 ]; then
				if [ "${daemon_mode}" != "1" ] ; then
					echo "move successful.  Alerting user.." >> "$log_file"
					myscript="${my_path}/mount_moved.scpt"
					osascript "$myscript" $daemon_mode $jname
				fi
			else
				
				echo "Move FAILED..." >> "$log_file"
			fi
		fi
	fi

	
done < $config_file

echo "Removing Magic File" >> "$log_file"
rm -v "$magic_file"



