#!/bin/bash
#
# User Share Launcher.  Main script that mounts shares for the user
#
# This script sources scripts to run per mount
# as defined in the configuration file
#
# Created by Andy Fuhr andy@nugeometry.com
###################################################################

# Boolean 0 = not daemon mode, 1 = daemon mode true
daemon_mode=$1

#Set my path
my_path=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
echo "$my_path"

#Set log file
if [ "$daemon_mode" == "1" ]; then

	log_file="/dev/null"
else

	log_file="/dev/tty"
fi
echo "$log_file"

# Check to see who is logging in gather information
user=`/usr/bin/stat -f '%Su' /dev/console`

#Source Config File
#source "${my_path}/config.txt"
config_file="${my_path}/system_share_launcher.config"


#Show enviroment
echo "Script run at" > "$log_file"
date >> "$log_file"
echo "my_path = ${my_path}" >> "$log_file"
echo "daemon_mode= ${daemon_mode}" >> "$log_file"
echo "" >> "$log_file"

#Read each line in the config file and execute its 
#file
while read line
do
	
	echo "Running ${line}" >> "$log_file"
	bash "$line" "${daemon_mode}"
	echo "Moving on to next file" >> "$log_file"
	
done < $config_file

#A strange thing can happen at login screen when running a Finder mount script
#where finder opens... It doesnt effect anything but can look weird
#this code checks for this and stops finder if it is running to clean up
echo "Checking to see if we are at login window..." >> "$log_file"
if [ "$user" == "root" ]; then
	echo "At login window. checking if Finder is running..." >> "$log_file"
	finder_pid=`ps -aef | grep [F]inder | awk '{print $2}'`
	echo "finder_pid = '${finder_pid}'" >> "$log_file"
	if [ "$finder_pid" != "" ]; then
		echo "Finder is running, stopping it..." >> "$log_file"
		kill $finder_pid
	fi
fi
echo "Done" >> "$log_file"
