#!/bin/bash
#
# User Share Launcher.  Main script that mounts shares for the user
#
# This script sources scripts to run per mount
# as defined in the configuration file
#
# Created by Andy Fuhr andy@nugeometry.com
###################################################################

# Boolean 0 = not daemon mode, 1 = daemon mode true
daemon_mode=$1

#Set my path
my_path=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
echo "$my_path"

#Set log file
log_file="/dev/tty"
echo "$log_file"

# Check to see who is logging in gather information
user=`/usr/bin/stat -f '%Su' /dev/console`

#Source Config File
#source "${my_path}/config.txt"
config_file="${my_path}/user_share_launcher.config"


#Show enviroment
echo "Script run at" > "$log_file"
date >> "$log_file"
echo "my_path = ${my_path}" >> "$log_file"
echo "daemon_mode= ${daemon_mode}" >> "$log_file"
echo "" >> "$log_file"

#Read each line in the config file and execute its 
#file
while read line
do
	
	echo "Running ${line}" >> "$log_file"
	bash "$line" "${daemon_mode}"
	echo "Moving on to next file" >> "$log_file"
	
done < $config_file

echo "Done" >> "$log_file"
